function [R,T]=factRT(sys,TES)
% FactRT retourne les facteurs de rflexion et de transmission en
%   courant de probabilit pour une particule soumise  une nergie
%   potentielle quelconque compose de discontinuits (objet marche).
%   [R,T]=FACTRT(sys)
%       >> sys  = nergie potentielle;
%       << R    = facteur de rflexion en courant de probabilit;
%       << T    = facteur de transmission en courant de probabilit.
%
%	Olivier Pujol : septembre 2013
%
if (nargin<1), error('Mauvais nombre d''argument d''entre !');end
%

nE=size(TES,2); % Nombre de valeurs de l'nergie
R=nan(1,nE);
T=nan(1,nE);

for iE=1:nE
    if ( (isreal(sys{iE}{1}(3))==1)&&(isreal(sys{iE}{1}(4))==1) )
        R(iE)=(abs(-TES{iE}(2,1)/TES{iE}(2,2)))^2;
        T(iE)=(1/abs(TES{iE}(2,2)))^2;
    end
%
    if ( (isreal(sys{iE}{1}(3))==1)&&(isreal(sys{iE}{1}(4))==0) )
        R(iE)=1;
        T(iE)=0;
    end
%
end

return;